import groovy.util.XmlParser
import groovy.json.JsonSlurper
import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*

/********************************************************************
 * MyiPlayer.com plugin for Serviio
 * 
 * @author X S Inattar
 *
 * Sample URLs to use as video webresource: 
 *    US Channels: http://www.myiplayer.com/uschannels.php
 *    UK Channels: http://www.myiplayer.com/ukchannels.php
 *    News: http://www.myiplayer.com/serieschannels.php
 *    Music: http://www.myiplayer.com/musicchannels.php
 *    Sports: http://www.myiplayer.com/sportchannels.php
 * 
 * Version:
 *    V1: August 03, 2012 - Initial Release
 *    V2: August 04, 2012 - Thumbnail Issue Fixed
 *    V3: August 09, 2012 - Bug Fix: Set live=true for the content.
 *    V4: August 10, 2012 - Added support for: viovu.com, liveflash.tv
 *    V5: August 21, 2012 - Added support for: wcast.tv
 *    V6: August 31, 2012 - Added support for: castup.tv
 *    V7: September 25, 2012 - Added support for: 9stream.com, skystreamlive.com, espnwatch.net
 * 
 ********************************************************************/
 
 class MyiPlayer extends WebResourceUrlExtractor {
 
    final VALID_FEED_URL = '^(?:http://)?(?:www\\.)?myiplayer\\.com/(.*?)channels\\.php'
    final MYIPLAYER = 'MyiPlayer'
    final MYIPLAYER_URL = 'http://www.myiplayer.com/'

    final CHANNELS_LIST_EXTRACTOR = '<td><a href="(.*?)".*?><img.*?src="(.*?)".*?></a></td>'
    final CHANNEL_SRC_EXTRACTOR = '<iframe.*?src="(.*?)"></iframe>'
    final CHANNEL_SEC_CODE_EXTRACTOR = '\\?(.*?)$'    
    final CHANNEL_NAME_EXTRACTOR = '<title>MyiPlayer\\.com - Watch (.*?) Online.*?</title>'
    
    final CHANNEL_HTML_URL_EXTRACTOR = '<iframe.*?src=".*?myiplayer\\.com/(.*?)".*?></iframe>'        
     
    String getExtractorName() {
        return 'myiplayer.com'
    }
    
    boolean extractorMatches(URL feedUrl) {
        return feedUrl ==~ VALID_FEED_URL
    }
   
    /**/
    void write_to_log(
        String text
    ) {
        log(text)
    }
    /**/
    
    Boolean URLExists(URL fileURL){
        if(((HttpURLConnection) fileURL.openConnection()).getResponseCode() == 404){
            return false
        }
        return true
    }

    // if looking for a particular URL in html           
    String process_for_URL(        
        String htmlText,
        String rgxMatcher,
        String baseURL
    ) {       
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            return_val = '-URL-' + baseURL + matcher[0][1]
        }        
        return return_val
    }
    
    String process_for_CUSTOMSTREAMMATCH(
        String htmlText,
        String rgxMatcher,
        String prefix,
        String postfix
    ) {
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            return_val = '-STREAM-' + prefix + matcher[0][1] + postfix
        }
        return return_val
    }
    
    // if only playpath is in the html
    String process_for_PLAYPATH(
        String htmlText,
        String rgxMatcher,
        String[] streamURLs,
        String baseURL,
        String swfURL        
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            
            def pageURL = baseURL + matcher[0][1]            
            def playpath = fix_playpath(matcher[0][1])
            
            def stream = streamURLs[ (int)(System.currentTimeMillis() % streamURLs.size()) ]
            stream = modify_stream_based_on_page_and_playpath(stream, pageURL, playpath)
            
            playpath = modify_playpath_based_on_page_url(playpath, pageURL)
            playpath = modify_playpath_based_on_swf_url(playpath, swfURL)            
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageURL
            return_val = return_val + ' swfUrl=' + swfURL
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    final ILIVE_STREAMS = [
        'rtmp://188.122.91.25/edge',
        'rtmp://199.241.187.194/edge',
        'rtmp://188.122.91.33/edge',
        'rtmp://188.122.91.23/edge',
        'rtmp://199.241.187.198/edge'
    ]
    final CASTALBA_STREAMS = [
        'rtmp://173.192.105.215/live',
        'rtmp://173.192.48.117/live',
        'rtmp://159.253.149.16/live'
    ]
    String redirect_to_actual_stream(String stream) {
        def actual_stream = stream
        def streamURLs = null
        if (stream.contains('ilive.to')) {            
            streamURLs = ILIVE_STREAMS
        }
        else if (stream.contains('castalba.tv')) {            
            streamURLs = CASTALBA_STREAMS
        }        
        
        if (streamURLs != null) {
            actual_stream = streamURLs[ (int)(System.currentTimeMillis() % streamURLs.size()) ]
        }
        
        return actual_stream
    }
    
    // modify_stream_based_on_page_url
    String modify_stream_based_on_page_and_playpath(String stream, String pageURL, String playpath) {
        def actual_stream = stream
        
        if (pageURL.contains("video.virginradioitaly.it") 
            || pageURL.contains("video.radiomontecarlo.net")
        ) {
            actual_stream = actual_stream.replaceFirst("auto\\|","rtmp://")
            actual_stream = actual_stream.replaceFirst("\\|",":1935/")
            actual_stream = actual_stream.replaceAll("\\|","/")
        }   
        else if (pageURL.contains("fcast.tv") 
        ) {
            if (
                playpath.contains("115517")
            ) {
                   actual_stream = actual_stream.replaceFirst("/live","/app")
            }
        }
        else if (pageURL.contains("wcast.tv") 
        ) {
            if (
                playpath.contains("tspn")
                || playpath.contains("stcric2")
                || playpath.contains("PtvSport")
                || playpath.contains("Geosuper")
                || playpath.contains("TenSports")
                || playpath.contains("discoveryhindi")
                || playpath.contains("GeoTv")
                || playpath.contains("GeoN")
                || playpath.contains("arydig")
                || playpath.contains("HumTv")
                || playpath.contains("Movies")
            ) {
                   actual_stream = actual_stream.replaceFirst(".tv/live",".tv/broadcast")
            }
        }     
        
        return actual_stream
    }
    
    String modify_playpath_based_on_page_url(String playpath, String pageURL) {
        def actual_playpath = playpath
        
        if (pageURL.contains("livecaster.tv") 
        ) {
            actual_playpath = actual_playpath + '.stream'
        }        
        else if (pageURL.contains("fcast.tv") 
        ) {
            if (
                actual_playpath.contains("115517")
            ) {
                actual_playpath = "geonewstv"
            }
        }
        else if (pageURL.contains("wcast.tv") 
        ) {
            if (
                actual_playpath.contains("tspn")
                || actual_playpath.contains("stcric2")
                || actual_playpath.contains("PtvSport")
            ) {
                actual_playpath = actual_playpath.toLowerCase()
            }
            else if (
                actual_playpath.contains("Geosuper")
            ) {
                actual_playpath = "13246540114814"
            }
            else if (
                actual_playpath.contains("TenSports")
            ) {
                actual_playpath = "1155200"
            }
            else if (
                actual_playpath.contains("discoveryhindi")
            ) {
                actual_playpath = "115521"
            }
            else if (
                actual_playpath.contains("GeoTv")
            ) {
                actual_playpath = "ent1"
            }
            else if (
                actual_playpath.contains("GeoN")
            ) {
                actual_playpath = "115517"
            }
            else if (
                actual_playpath.contains("arydig")
            ) {
                actual_playpath = "111206"
            }
            else if (
                actual_playpath.contains("HumTv")
            ) {
                actual_playpath = "115520"
            }
            else if (
                actual_playpath.contains("Movies")
            ) {
                actual_playpath = "115518"
            }
            else {
                actual_playpath = actual_playpath + '.stream'
            }
        }    
        
        return actual_playpath
    }
    
    
    String modify_stream_based_on_swf_url(String stream, String swfURL) {
        def actual_stream = stream
        
        if (swfURL.contains('awooze.com')) {
            actual_stream = actual_stream + '/'
        }
        else if (swfURL.contains('vitalstreamcdn.com')) {
            actual_stream = actual_stream + '/'
        }
        else if (swfURL.contains('myfoxtampabay.com')) {
            actual_stream = actual_stream + '/live'
        }
        else if (swfURL.contains('php.chol.com')) {
            actual_stream = actual_stream + '/'
        }
        
        return actual_stream
    }
    
    String modify_playpath_based_on_swf_url(String playpath, String swfURL) {
        def actual_playpath = playpath
        
        return actual_playpath
    }
    
    String fix_playpath(String playpath) {
        def actual_playpath = playpath
        
        actual_playpath = actual_playpath.replaceAll(".flv", "")
        actual_playpath = java.net.URLDecoder.decode(actual_playpath)
        
        return actual_playpath
    }   
    
    
    String process_for_SWF_STREAMER_PLAYPATH(
        String htmlText,
        String rgxMatcher,
        String pageUrl
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            def swfUrl = matcher[0][1] + '.swf'
            def playpath = fix_playpath(matcher[0][3])
            def stream = matcher[0][2]
            stream = modify_stream_based_on_page_and_playpath(stream, pageUrl, playpath)
            stream = modify_stream_based_on_swf_url(stream, swfUrl)
            stream = redirect_to_actual_stream(stream)
            
            
            playpath = modify_playpath_based_on_page_url(playpath, pageUrl)
            playpath = modify_playpath_based_on_swf_url(playpath, swfUrl)
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageUrl
            return_val = return_val + ' swfUrl=' + swfUrl
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    String process_for_STREAMER_PLAYPATH(
        String htmlText,
        String rgxMatcher,
        String pageUrl
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
        
            def stream = matcher[0][1]
            def playpath = fix_playpath(matcher[0][2])
            
            stream = modify_stream_based_on_page_and_playpath(stream, pageUrl, playpath)
            stream = redirect_to_actual_stream(stream)
            
            
            playpath = modify_playpath_based_on_page_url(playpath, pageUrl)
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageUrl
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    String process_for_ENCODED_URL(
        String htmlText,
        String rgxMatcher,
        String baseURL
    ) {
        def return_val = '-NOTFOUND-'
        def matcher = htmlText =~ "document\\.write\\(unescape\\('(.*?)'\\)\\);"
        String encoded_HTML = ''
        String decoded_HTML = ''
        def encoded_HTML_count = matcher.count
        if (encoded_HTML_count > 0) {
            for (i in 0..<encoded_HTML_count) {                
                encoded_HTML = encoded_HTML + matcher[i][1] + ' '
            }
            decoded_HTML = java.net.URLDecoder.decode(encoded_HTML)
            def decoded_matcher = decoded_HTML =~ rgxMatcher
            if (decoded_matcher.count > 0) {
                return_val = '-URL-' + baseURL + decoded_matcher[0][1]
            }
        }
        return  return_val
    }
    
    String process_for_SWF_PLAYPATH_STREAMER(
        String htmlText,
        String rgxMatcher,
        String pageUrl
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            
            def swfUrl = matcher[0][1] + '.swf'
            def playpath = fix_playpath(matcher[0][2])
            def stream = matcher[0][3]
            stream = modify_stream_based_on_page_and_playpath(stream, pageUrl, playpath)
            stream = modify_stream_based_on_swf_url(stream, swfUrl)
            stream = redirect_to_actual_stream(stream)
            
            
            playpath = modify_playpath_based_on_page_url(playpath, pageUrl)
            playpath = modify_playpath_based_on_swf_url(playpath, swfUrl)
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageUrl
            return_val = return_val + ' swfUrl=' + swfUrl
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    String process_for_USTREAM(
        String ustream_channel_id
    ) {
                
        def dataurl = 'http://cgw.ustream.tv/Viewer/getStream/1/' + ustream_channel_id + '.amf'
        def data = new URL(dataurl).getText()
        
        def playpath_matcher = data =~ "streamName\\W\\W\\W(.+?)\\x00"
        if (playpath_matcher.count <= 0) {
            return '-USTREAMNOTLIVE-'
        }
        def playpath = playpath_matcher[0][1]
        
        def rtmpurl = ''
        def tcurl_matcher_1 = data =~ "cdnUrl\\W\\W\\S(.*?)\\x00"
        if (tcurl_matcher_1.count > 0) {
            rtmpurl = tcurl_matcher_1[0][1]
        }
        else {
            def tcurl_matcher_2 = data =~ "fmsUrl\\W\\W\\S(.*?)\\x00"
            if (tcurl_matcher_2.count > 0) {
                rtmpurl = tcurl_matcher_2[0][1]
                rtmpurl = rtmpurl.replaceAll('/ustreamVideo', ':1935/ustreamVideo')
                rtmpurl = rtmpurl + '/'
            }
            else {
                return '-USTREAMNOTLIVE-'
            }
        }
        
        return '-STREAM-' + rtmpurl + ' playpath=' + playpath + ' swfUrl=http://static-cdn1.ustream.tv/swf/live/viewer.rsl:96.swf' + ' swfVfy=1 live=1'
    }
    
    Boolean channelOffline(
        String htmlText, 
        String offlineChecker
    ) {        
        def offline_check = htmlText =~ offlineChecker
        if (offline_check.count > 0) {
            return true
        }
        return false
    }         
    
    Boolean streamNotSupported(
        String htmlText, 
        String streamNotSupportedChecker
    ) {        
        def notsupported_check = htmlText =~ streamNotSupportedChecker
        if (notsupported_check.count > 0) {
            return true
        }
        return false
    }
    
    String processChannel(
        String channel_url
    )
    {
        def log_text = ''
        def error = ''   
        
        if (!URLExists(new URL(channel_url))) {
            error = '-DEADLINK-'
            log_text = log_text + error
            print error
            write_to_log(log_text)
            return error
        }
        
        def channel_src_text = new URL(channel_url).getText()                        
        /**
        def channel_src_matcher = channel_url_text =~ CHANNEL_SRC_EXTRACTOR
        if (channel_src_matcher.count <= 0) {
            error = '-SRCNOTFOUND-'
            log_text = log_text + error
            print error
            write_to_log(log_text)
            return error
        }
        def channel_src = channel_src_matcher[0][1] 
        log_text = log_text + channel_src
        print channel_src
        log_text = log_text + " - "           
        print ' - '
        if (channel_src.contains("adbrite.php")) {
            error = '-ADSLINK-'
            log_text = log_text + error
            print error
            write_to_log(log_text)
            return error
        }                                                         
        channel_src_text = new URL(channel_src).getText()
        /**/
//        channel_src_text = channel_src_text.replaceAll("\n", "")        
//        channel_src_text = channel_src_text.replaceAll("\r","")
        channel_src_text = channel_src_text.replaceAll('%3A',':')
        channel_src_text = channel_src_text.replaceAll('%2F','/')
        channel_src_text = channel_src_text.replaceAll('&amp;','&')                                         
        channel_src_text = channel_src_text.replaceAll('&quot;','"')                                         
        channel_src_text = channel_src_text.replaceAll('&lt;','<')                                         
        channel_src_text = channel_src_text.replaceAll('&gt;','>')                                                                 
        channel_src_text = channel_src_text.replaceAll('%2D','-')

        /**
        def channel_name_matcher = channel_src_text =~ CHANNEL_NAME_EXTRACTOR
        if (channel_name_matcher.count <= 0) {
            error = '-NAMENOTFOUND-'           
            log_text = log_text + error
            print error
            write_to_log(log_text)
            return error
        }
        def channel_name = channel_name_matcher[0][1]
        channel_name = channel_name.replaceAll("AND", "&")
        log_text = log_text + channel_name
        print channel_name
        log_text = log_text + ' '
        print ' '
        /**/
        
        def channel_stream_url_text = channel_src_text            
        def url_found = 0          
        def loop = 0  
        def base_url = ''
        def current_url = channel_url //channel_src
        def rtmp_url = ''            
        while (url_found == 0) {
            if (channelOffline(channel_stream_url_text, '<iframe src="http://www.watchmytv.net/images/blank.jpg"')
                || channelOffline(channel_stream_url_text, '<iframe src="http://www.watchtelevision.eu/images/blank.jpg"')
                || channelOffline(channel_stream_url_text, '<h1 class="center">This channel is offline\\.</h1>')
                || channelOffline(channel_stream_url_text, '<h4 class=.*?THIS CHANNEL IS CURRENTLY OFFLINE</h4>')
                ) {
                error = '-OFFLINE-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                return error
            }
            
            if (streamNotSupported(channel_stream_url_text, '<media url="rtmfp://.*?/>')
                    || streamNotSupported(channel_stream_url_text, '<script.*?src=".*?player\\.ooyala\\.com.*?"></script>')
                    || streamNotSupported(channel_stream_url_text, '<embed.*?src=".*?player\\.ooyala\\.com.*?">')
                    || streamNotSupported(channel_stream_url_text, '<script.*?src=".*?hdmytv\\.com.*?"></script>')
                    || streamNotSupported(channel_stream_url_text, '<embed.*?src=".*?livestream\\.com')
                    || streamNotSupported(channel_stream_url_text, '<iframe.*?src=".*?livestream\\.com')
                    || streamNotSupported(channel_stream_url_text, "javascript:popUp\\('.*?livestream\\.com.*?'\\)")
                    || streamNotSupported(channel_stream_url_text, "javascript:popUp\\('.*?justin\\.tv.*?'\\)")                        
                    || streamNotSupported(channel_stream_url_text, '<iframe.*?src=".*?hitsports\\.net.*?</iframe>')
                    || streamNotSupported(channel_stream_url_text, '<iframe.*?src=".*?televisaofutebol\\.com.*?">')
                    || streamNotSupported(channel_stream_url_text, '<iframe.*?src=".*?mypremium\\.tv.*?">')                    
                    || streamNotSupported(channel_stream_url_text, '<embed.*?src=".*?tikilive\\.com')
                    || streamNotSupported(channel_stream_url_text, '<iframe.*?src=".*?streami\\.tv')
                    || streamNotSupported(channel_stream_url_text, '<script.*?src=".*?static\\.castto\\.me.*?"></script>')
                    || streamNotSupported(channel_stream_url_text, "<script.*?src='.*?sawlive\\.tv.*?'></script>")
                    ) {
                error = '-NOTSUPPORTED-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                return error
            }
            
            def returned_url = '-NOTFOUND-'
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '(?s)<embed.*?src="(.*?)\\.swf".*?streamer=(.*?)&file=(.*?)\\.flv.*?</embed>',
                    current_url
                )
            }            
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '<embed.*?src="(.*?)\\.swf".*?file=(.*?)&id=(.*?)&autostart',
                    current_url
                )
            }      
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    "(?s)object.*?<param name='movie' value='(.*).swf'.*?<param name='flashvars'.*?streamer=(.*?)'>.*?flashvars='file=(.*?).flv",
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    '(?s)<embed src="(.*?)\\.swf".*?stream1=(.*?)&.*?&serverAppInstName=(.*?)&',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '<embed.*?src="(.*?)\\.swf.*?file=(.*?)&id=(.*?)&overstretch=fit">',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    "(?s)object.*?<param name='movie' value='(.*).swf'.*?<param name='flashvars'.*?file=(.*?)&.*?streamer=(.*?)&.*?>",
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '(?s)EMBED.*?src="(.*).swf".*?flashvars=".*?&file=(.*?)&id=(.*?)&.*?"',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '(?s)object.*?data="(.*).swf".*?<param name="flashvars".*?streamer=(.*?)&file=(.*?)&',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    "(?s)<script.*?SWFObject\\('(.*?).swf',.*?addVariable\\('file'.*?'(.*?)'\\);.*?addVariable\\('streamer'.*?'(.*?)'\\);",
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    "(?s)<script.*?SWFObject\\(\"(.*?).swf\",.*?addVariable\\('streamer','(.*?)'\\);.*?addVariable\\('file','(.*?)'\\);",
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '.*?StreamURL="(.*?)\\.swf\\?streamer=(.*?)&file=(.*?)&controlbar=false"',
                    current_url
                )                                
            }
            if (returned_url == '-NOTFOUND-' ) {                                  
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    "(?s)<script.*?'flashplayer':.*?\"(.*?).swf\".*?'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'",
                    current_url
                )                   
            }
            if (returned_url == '-NOTFOUND-' ) {                                  
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    '(?s)<object.*?data="(.*?).swf".*?<param name="flashvars".*?file=(.*?)&.*?streamer=(.*?)&.*?</object>',
                    current_url
                )                   
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe src="(.*?).swf.*?streamer=(.*?)&file=(.*?)" marginheight="0" marginwidth="0" frameborder="0" height="100%" scrolling="NO" width="100%"></iframe>',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '<embed src="(.*?).swf".*?flashvars=".*?&file=(.*?)&line.*?&id=(.*?)&line',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    '<embed.*?src="(.*?)\\.swf".*?flashvars="file=(.*?).flv&streamer=(.*?)&',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '<object.*?data="(.*?)\\.swf\\?src=(.*?)/live/(.*?)&autostart.*?">',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_STREAMER_PLAYPATH(
                    channel_stream_url_text,
                    '(?s)<serverPath value="(.*?)".*?<rate n=.*?streamName="(.*?)" bitrate=',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_SWF_PLAYPATH_STREAMER(
                    channel_stream_url_text,
                    '(?s)flashplayer: "(.*?).swf",.*?<location>(.*?)</location><meta rel="streamer">(.*?)</meta><meta rel',
                    current_url
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_CUSTOMSTREAMMATCH(
                    channel_stream_url_text,
                    '(?s)<param.*?value="rtsp://(.*?)">',
                    'rtsp://',
                    ''                        
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_CUSTOMSTREAMMATCH(
                    channel_stream_url_text,
                    '(?s)<object.*?type="application/x-oleobject".*?"MediaPlayer".*?<param name="FileName" value="http://(.*?)">',
                    'rtsp://',
                    ''
                )
            }
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_CUSTOMSTREAMMATCH(
                    channel_stream_url_text,
                    '(?s)<embed.*?type="application/x-mplayer2".*?src="MMS://(.*?)".*?>',
                    'mmsh://',
                    ''
                )
            }                
            if (returned_url == '-NOTFOUND-' ) {
                returned_url = process_for_CUSTOMSTREAMMATCH(
                    channel_stream_url_text,
                    '<iframe.*?src="(.*?)://video\\.radiomontecarlo\\.net',
                    'http://video.radiomontecarlo.net/com/universalmind/tv/rmc/videoXML.xml',
                    ''
                )
                
                if (returned_url != '-NOTFOUND-') {
                    returned_url = returned_url.replaceAll("videoXML.xmlhttp", "videoXML.xml")
                    returned_url = returned_url.replaceFirst("-STREAM-", "-URL-")
                }
            }   
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '(?s)<object.*?data=".*?ustream.tv.*?<param name="flashvars" value="cid=(.*?)&.*?</object>',
                    ''
                )                                        
                
                if (returned_url != '-NOTFOUND-') {
                    returned_url = returned_url.replaceFirst("-URL-", "")                    
                    returned_url = process_for_USTREAM(returned_url)
                    
                    if (returned_url == '-USTREAMNOTLIVE-') {
                        error = '-USTREAMNOTLIVE-'
                        log_text = log_text + error
                        print error
                        write_to_log(log_text)
                        return error
                    }
                }
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?ustream\\.tv/embed/(.*?)\\?',
                    ''
                )                                        
                
                if (returned_url != '-NOTFOUND-') {
                    returned_url = returned_url.replaceFirst("-URL-", "")                    
                    returned_url = process_for_USTREAM(returned_url)
                    
                    if (returned_url == '-USTREAMNOTLIVE-') {
                        error = '-USTREAMNOTLIVE-'
                        log_text = log_text + error
                        print error
                        write_to_log(log_text)
                        return error
                    }
                }
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '(?s)<object.*?<param name="flashvars" value="cid=(.*?)&.*?<param name="src" value=".*?ustream\\.tv.*?</object>',
                    ''
                )                                        
                
                if (returned_url != '-NOTFOUND-') {
                    returned_url = returned_url.replaceFirst("-URL-", "")                    
                    returned_url = process_for_USTREAM(returned_url)
                    
                    if (returned_url == '-USTREAMNOTLIVE-') {
                        error = '-USTREAMNOTLIVE-'
                        log_text = log_text + error
                        print error
                        write_to_log(log_text)
                        return error
                    }
                }
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)".*?src=".*?110cast\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://fms1.110cast.com/tv'
                    ],
                    'http://www.110cast.com/embed.php?v=',
                    'http://www.110cast.com/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)".*?src=".*?veemi\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://68.68.30.164/live',
                        'rtmp://76.10.221.69/live',
                        'rtmp://76.10.221.71/live',
                        'rtmp://68.68.26.104/live',
                        'rtmp://68.68.30.134/live'
                    ],
                    'http://www.veemi.com/embed.php?v=',
                    'http://www.veemi.com/player/player-licensed.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe.*?src=".*?skystreamlive\\.com.*?n=(.*?)&vw=.*?">',
                    (String[])[    
                        'rtmp://198.154.96.139/live'
                    ],
                    'http://www.skystreamlive.com/embedE.php?n=',
                    'http://www.skystreamlive.com/player/skystreamlive.com.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?channel="(.*?)".*?src=".*?skystreamlive\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://198.154.96.139/live'
                    ],
                    'http://www.skystreamlive.com/embedE.php?n=',
                    'http://www.skystreamlive.com/player/skystreamlive.com.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)".*?src=".*?viovu\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://199.189.110.228:1935/live',
                        'rtmp://199.189.110.220:1935/live'
                    ],
                    'http://www.viovu.com/embed.php?fileid=',
                    'http://www.viovu.com/player/player.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?channel='(.*?)'.*?src='.*?liveflash\\.tv.*?'></script>",
                    (String[])[    
                        'rtmp://208.43.175.45/stream',
                        'rtmp://31.204.154.63/stream',
                        'rtmp://108.170.10.2/stream'
                    ],
                    'http://www.liveflash.tv/embedplayer/',
                    'http://www.liveflash.tv/resources/scripts/eplayer.swf'
                )
            } 
             if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "onClick=\"javascript:popUp\\('.*?liveflash\\.tv/(.*?)'\\)\"></a><a.*?></a><a.*?><img.*?></a>",
                    (String[])[    
                        'rtmp://208.43.175.45/stream',
                        'rtmp://31.204.154.63/stream',
                        'rtmp://108.170.10.2/stream'
                    ],
                    'http://www.liveflash.tv/embedplayer/',
                    'http://www.liveflash.tv/resources/scripts/eplayer.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)';.*?src='.*?livecaster\\.tv.*?'></script>",
                    (String[])[    
                        'rtmp://cdn.livecaster.tv/live'
                    ],
                    'http://www.livecaster.tv/embed.php?u=',
                    'http://www.livecaster.tv/player/player.swf'
                )
            } 
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)';.*?src='.*?wcast\\.tv.*?'></script>",
                    (String[])[    
                        'rtmp://live.wcast.tv/live'
                    ],
                    'http://www.wcast.tv/embed.php?u=',
                    'http://www.wcast.tv/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)";.*?src=".*?wcast\\.tv.*?"></script>',
                    (String[])[    
                        'rtmp://live.wcast.tv/live'
                    ],
                    'http://www.wcast.tv/embed.php?u=',
                    'http://www.wcast.tv/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "onClick=\"javascript:popUp\\('.*?veemi\\.com/watch\\?v=(.*?)'\\)\"></a><a.*?></a><a.*?><img.*?></a>",
                    (String[])[    
                        'rtmp://68.68.30.164/live',
                        'rtmp://76.10.221.69/live',
                        'rtmp://76.10.221.71/live',
                        'rtmp://68.68.26.104/live',
                        'rtmp://68.68.30.134/live'
                    ],
                    'http://www.veemi.com/embed.php?v=',
                    'http://www.veemi.com/player/player-licensed.swf'
                )
            } 
           
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)".*?src=".*?yycast\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://188.122.86.207:1935/live',
                        'rtmp://188.122.86.234:1935/live',
                        'rtmp://188.122.86.230:1935/live'
                    ],
                    'http://www.yycast.com/embed.php?fileid=',
                    'http://cdn.yycast.com/player/player.swf'
                )
            }                                
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "javascript:popUp.*?yycast\\.com/(.*?)'\\)",
                    (String[])[    
                        'rtmp://188.122.86.207:1935/live',
                        'rtmp://188.122.86.234:1935/live',
                        'rtmp://188.122.86.230:1935/live'
                    ],
                    'http://www.yycast.com/embed.php?fileid=',
                    'http://cdn.yycast.com/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    'src=".*?skyonetv\\.com/skyembed\\.php\\?n=(.*?)"',
                    (String[])[    
                        'rtmp://198.154.96.141/live'
                    ],
                    'http://www.skyonetv.com/skyembed.php?n=',
                    'http://www.skyonetv.com/player/skyonetv.com.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    'src=".*?skyonecast\\.com/skyembed3\\.php\\?n=(.*?)"',
                    (String[])[    
                        'rtmp://198.154.96.141/live'
                    ],
                    'http://www.skyonecast.com/skyembed3.php?n=',
                    'http://www.skyonecast.com/player/skyonecast.com.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    'src=".*?skyonetv\\.com/skyone\\.php\\?n=(.*?)"',
                    (String[])[    
                        'rtmp://198.154.96.141/live'
                    ],
                    'http://www.skyonetv.com/skyone.php?n=',
                    'http://www.skyonetv.com/player/skyonecast.com.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe.*?src=".*?fcast\\.tv/watch\\.php\\?live=(.*?)".*?>',
                    (String[])[    
                        'rtmpe://31.204.154.55:1935/live',
                        'rtmp://31.204.154.61/live'
                    ],
                    'http://www.fcast.tv/embed.php?live=',
                    'http://www.fcast.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)';.*?src='.*?fcast\\.tv",
                    (String[])[    
                        'rtmpe://31.204.154.55:1935/live',
                        'rtmp://31.204.154.61/live'
                    ],
                    'http://www.fcast.tv/embed.php?live=',
                    'http://www.fcast.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "(?s)<script.*?id='(.*?)';.*?src='.*?espnwatch\\.net",
                    (String[])[    
                        'rtmp://62.212.72.173:443/liverepeater',
                        'rtmp://204.155.152.144:443/liverepeater'
                    ],
                    'http://espnwatch.net/embed.php?id=',
                    'http://cdn.espnwatch.net/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)";.*?src=".*?blive\\.me',
                    (String[])[    
                        'rtmp://67.215.244.178/live',
                        'rtmp://67.215.243.218/live'
                    ],
                    'http://www.blive.me/embed.php?v=',
                    'http://static.blive.me/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)';.*?src='.*?110cast\\.com",
                    (String[])[    
                        'rtmp://fms1.110cast.com/tv'
                    ],
                    'http://www.110cast.com/embed.php?u=',
                    'http://www.110cast.com/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?src='.*?sawlive\\.tv/embed/(.*?)'></script>",
                    (String[])[    
                        'rtmp://68.68.17.102/app',
                        'rtmp://68.68.31.219/app'
                    ],
                    'http://www.sawlive.tv/v/',
                    'http://static2.sawlive.tv/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)".*?src=".*?webcaston\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://c31.webcaston.com/live/channel/',
                        'rtmp://c71.webcaston.com/live/channel/'
                    ],
                    'http://www.webcaston.com/embed.php?fileid=',
                    'http://www.webcaston.com/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)'.*?src='.*?launchlive\\.tv.*?'></script>",
                    (String[])[    
                        'rtmpe://95.211.174.130/live',
                        'rtmp://95.211.174.130/live',
                    ],
                    'http://www.launchlive.tv/channel.php?v=',
                    'http://launchlive.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe.*?src=".*?launchlive\\.tv/embed\\.php\\?v=(.*?)&',
                    (String[])[    
                        'rtmpe://95.211.174.130/live',
                        'rtmp://95.211.174.130/live',
                    ],
                    'http://www.launchlive.tv/channel.php?v=',
                    'http://launchlive.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)'.*?src='.*?110cast\\.com.*?'></script>",
                    (String[])[    
                        'rtmp://fms1.110cast.com/tv'
                    ],
                    'http://www.110cast.com/embed.php?u=',
                    'http://www.110cast.com/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    "<script.*?fid='(.*?)'.*?src='.*?casti\\.tv.*?'></script>",
                    (String[])[    
                        'rtmp://31.204.153.82/live'
                    ],
                    'http://www.casti.tv/embed.php?v=',
                    'http://casti.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe.*?src=".*?casti\\.tv/embed\\.php\\?v=(.*?)"',
                    (String[])[    
                        'rtmp://31.204.153.82/live'
                    ],
                    'http://www.casti.tv/embed.php?v=',
                    'http://casti.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<iframe.*?src=".*?casti\\.tv/channel\\.php\\?v=(.*?)"',
                    (String[])[    
                        'rtmp://31.204.153.82/live'
                    ],
                    'http://www.casti.tv/embed.php?v=',
                    'http://casti.tv/player/player-licensed.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)"; v_width=.*?src=".*?tvcaston\\.com.*?"></script>',
                    (String[])[    
                        'rtmp://199.189.104.68:1935/live',
                        'rtmp://199.189.110.244:1935/live',
                        'rtmp://199.189.107.204:1935/live'
                    ],
                    'http://www.tvcaston.com/embed.php?fileid=',
                    'http://tvcaston.com/player/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') {
                returned_url = process_for_PLAYPATH(
                    channel_stream_url_text,
                    '<script.*?fid="(.*?)"; v_width=.*?src=".*?castup\\.tv.*?"></script>',
                    (String[])[    
                        'rtmp://95.211.191.35:80/live',
                        'rtmp://95.211.185.39:80/live',
                        'rtmp://95.211.185.40:80/live'
                    ],
                    'http://www.castup.tv/embed.php?u=',
                    'http://i1168.photobucket.com/albums/r496/castuptv/player.swf'
                )
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?znewsnow\\.com/(.*?)".*?></iframe>',
                    'http://znewsnow.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?domitv\\.com/(.*?)".*?></iframe>',
                    'http://domitv.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    "'.*?tvborinquen\\.com/(.*?)'\\)",
                    'http://tvborinquen.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?tvborinquen\\.com/(.*?)".*?></iframe>',
                    'http://tvborinquen.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=.*?prvideonetwork\\.com/(.*?)></iframe>',
                    'http://prvideonetwork.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    'src=".*?veohcast\\.tv/veohV\\.php\\?n=(.*?)"',
                    'http://www.veohcast.tv/veohV.php?n='
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?tv-msn\\.com/(.*?)".*?></iframe>',
                    'http://tv-msn.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?rdradio\\.com/(.*?)".*?></iframe>',
                    'http://rdradio.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?watchmytv\\.net/(.*?)".*?></iframe>',
                    'http://watchmytv.net/'
                ) 
            }            
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '(?s)<iframe.*?src=".*?watchtelevision\\.eu/(.*?)".*?</iframe>',
                    'http://www.watchtelevision.eu/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?streamtivi\\.com/embedplayer\\.php\\?id=(.*?)&.*?"></iframe>', 
                    'http://peer-stream.com/api/get_manifest.f4m?groupspec='
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<script.*?id="(.*?)".*?src=".*?streamtivi\\.com/jsplayerembed\\.js"></script>', 
                    'http://peer-stream.com/api/get_manifest.f4m?groupspec='
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<script.*?src=".*?9stream\\.com.*?channel=(.*?)&.*?">',
                    'http://www.9stream.com/embedplayer.php?channel='
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<script.*?id="(.*?)".*?<script.*?src=".*?castalba\\.tv.*?">',
                    'http://castalba.tv/embed.php?cid='
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<script.*?src=".*?ilive\\.to/embed/(.*?)&.*?"></script>',
                    'http://www.ilive.to/view/'
                ) 
            }                
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?ilive\\.to/embedplayer\\.php.*?channel=(.*?)&.*?</iframe>',
                    'http://www.ilive.to/view/'
                ) 
            }                
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?aajnetworks\\.com/channels/(.*?)".*?</iframe>',
                    'http://www.aajnetworks.com/channels/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?urfavchannels\\.in/channels/(.*?)".*?</iframe>',
                    'http://www.urfavchannels.in/channels/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?desistreams\\.tv/embed/(.*?)\\?.*?</iframe>',
                    'http://desistreams.tv/embed/'
                ) 
            }               
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    "<iframe.*?SRC='.*?desistreams\\.tv/embed/(.*?)' width='.*?</iframe>",
                    'http://desistreams.tv/embed/'
                ) 
            } 
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<IFRAME.*?SRC=".*?leton\\.tv/player\\.php\\?streampage=(.*?)&.*?"></IFRAME>',
                    'http://leton.tv/player.php?streampage='
                ) 
            }
            if (returned_url == '-NOTFOUND-') {                     
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    'cricfree\\.tv/update/(.*?)" id="myfr',
                    'http://cricfree.tv/update/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') {                     
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    'deluxemusic\\.tv\\.staging\\.ipercast\\.net/(.*?)" height=',
                    'http://deluxemusic.tv.staging.ipercast.net/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') {                     
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    'file:.*?deluxemusic\\.tv\\.staging\\.ipercast\\.net/(.*?)",',
                    'http://deluxemusic.tv.staging.ipercast.net/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') {                     
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<param name="movie".*?xmlPath=.*?video\\.virginradioitaly\\.it/(.*?)" />',
                    'http://video.virginradioitaly.it/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') {                     
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?coolsport\\.tv/(.*?)" height=.*?</iframe>',
                    'http://coolsport.tv/'
                ) 
            }
             if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '<iframe.*?src=".*?dmastiers\\.com/videos/(.*?)" width=.*?></iframe>',
                    'http://www.dmastiers.com/videos/'
                )                 
            }
            
            if (returned_url == '-NOTFOUND-') {                                     
                returned_url = process_for_ENCODED_URL(
                    channel_stream_url_text,
                    'tiiveni\\.allcx\\.com/(.*?)" scrolling="No" height="100%" width="100%"',
                    'http://tiiveni.allcx.com/'
                ) 
            }                 
            if (returned_url == '-NOTFOUND-') {                                     
                returned_url = process_for_ENCODED_URL(
                    channel_stream_url_text,
                    'watchtelevision\\.eu/(.*?)"',
                    'http://watchtelevision.eu/'
                ) 
            }      
            
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    '(?s)<iframe.*?src=".*?myiplayer\\.com/(.*?)".*?</iframe>', 
                    'http://www.myiplayer.com/'
                ) 
            }
            if (returned_url == '-NOTFOUND-') { 
                returned_url = process_for_URL(
                    channel_stream_url_text, 
                    "onClick=\"javascript:popUp\\('http://myiplayer\\.com/(.*?)'\\)\"", 
                    'http://www.myiplayer.com/'
                ) 
            }                             
             
            log_text = log_text + returned_url    
            log_text = log_text + ' '
            print returned_url + ' '
            
            if (returned_url == '-NOTFOUND-') {
                error = '-NOTFOUND-'
                write_to_log(log_text)
                return error
            }            
            else if (returned_url.contains("-URL-")) {
                returned_url = returned_url.replaceFirst("-URL-","")
                current_url = returned_url
                if (!URLExists(new URL(current_url))) {
                    error = '-DEADLINK-'
                    log_text = log_text + error
                    print error
                    write_to_log(log_text)
                    return error
                }
//                channel_stream_url_text = new URL(current_url).getText()
                channel_stream_url_text = openURL( new URL(current_url),
                    "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
//                channel_stream_url_text = channel_stream_url_text.replaceAll("\n","")
//                channel_stream_url_text = channel_stream_url_text.replaceAll("\r","")
                channel_stream_url_text = channel_stream_url_text.replaceAll('%3A',':')
                channel_stream_url_text = channel_stream_url_text.replaceAll('%2F','/')
                channel_stream_url_text = channel_stream_url_text.replaceAll('&amp;','&')                                         
                channel_stream_url_text = channel_stream_url_text.replaceAll('&quot;','"')                                                         
                channel_stream_url_text = channel_stream_url_text.replaceAll('%2D','-')
                channel_stream_url_text = channel_stream_url_text.replaceAll('&lt;','<')                                         
                channel_stream_url_text = channel_stream_url_text.replaceAll('&gt;','>')                                                                 
                
                
                /**                
                    println channel_stream_url_text
                    println ''
                    println ''                        
                    println ''
                    println ''
                    println ''                                                                                        
                /**/
            }
            else if (returned_url.contains("-STREAM-")) {
                rtmp_url = returned_url
                url_found = 1
            }                
        }
        
        write_to_log(log_text)
        
        return rtmp_url
    }
    
    WebResourceContainer extractItems(URL resourceUrl, int maxItemsToRetrieve) {
    
        List<WebResourceItem> items = []
        
        def nameMatcher = resourceUrl.toString() =~ VALID_FEED_URL
        def showTitle = MYIPLAYER + ' - ' + nameMatcher[0][1].toUpperCase() + ' Channels'
        println showTitle
        
        def cache_key_prefix = MYIPLAYER + '_' + nameMatcher[0][1].toUpperCase() + '_'
        
        def channelsText = resourceUrl.getText()
        channelsText = channelsText.replaceAll("\n", "");
        channelsText = channelsText.replaceAll("<!--.*?-->","")

        def channelsListMatcher = channelsText =~ CHANNELS_LIST_EXTRACTOR
        if (channelsListMatcher.count <= 0) {
            return null
        }
        int channels_count = channelsListMatcher.size()
        
        def channel_url
        def thumbnail_url
        def CHANNEL_STREAM_EXTRACTOR
               
        for (channel_number in 0..<channels_count) {
//        for (channel_number in 30..<33) {
        
            channel_url = MYIPLAYER_URL + channelsListMatcher[channel_number][1]
            thumbnail_url = MYIPLAYER_URL + channelsListMatcher[channel_number][2]                       
            
            //print channel_number
            //print ' - '  
            
            def log_text = channel_number + ' - ' + channel_url + ' - '
            println ''
            print channel_number + ' - ' + channel_url + ' - '                   
            def error = ''     
            
            if (channel_url.contains("/wmp.php?")
                || channel_url.contains("/iplayer-")
                || channel_url.contains("/vlcff.php?")                
                || channel_url.contains("-player.php")
                || channel_url.contains("/flash.php?")                                
            )  {
                error = '-NOTSUPPORTED-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                continue
            }
            
            if (channel_url.contains("/veetlesports.php")
                || channel_url.contains("/justinsports.php")                                          
                || channel_url.contains("veetlesite")
            )  {
                error = '-NOTACHANNEL-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                continue
            }
        
            def channel_sec_code_matcher = channel_url =~ CHANNEL_SEC_CODE_EXTRACTOR
            if (channel_sec_code_matcher.count <= 0) {
                error = '-SECCODENOTFOUND-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                continue
            }
            def channel_sec_code = channel_sec_code_matcher[0][1]
            log_text = log_text + channel_sec_code + ' - '
            if (channel_sec_code.contains("tvguide") 
                || channel_sec_code.contains("event")
                || channel_sec_code.contains("forum")
                || channel_sec_code.contains("graboid")
                || channel_sec_code.contains("tv player")
                || channel_sec_code.contains("tv%20player")                
                || channel_sec_code.contains("readbbcnews")
                || channel_sec_code.contains("mashable")
                || channel_sec_code.contains("soundcloud")
                || channel_sec_code.contains("pyramidkey")
                || channel_sec_code.contains("hello2spain")
                || channel_sec_code.contains("foxsite")                     
                || channel_sec_code.contains("bbcolympics")                     
                || channel_sec_code.contains("london2012")                     
                || channel_sec_code.contains("bbciplayer")                     
                || channel_sec_code.contains("allradio")                                     
                || channel_sec_code.contains("radiojazzfm")
                || channel_sec_code.contains("capitalfm")                
                || channel_sec_code.contains("mtvsite")                                
                || channel_sec_code.contains("sopcast")
                || channel_sec_code.contains("antena3catchup")                
                || channel_sec_code.contains("zensatv")                                
                || channel_sec_code.contains("solymartv")                                                
                || channel_sec_code.contains("sportstoday")                                                                
            ) {
                error = '-NOTACHANNEL-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                continue
            }            
            
            if (channel_sec_code.contains("girlsnextdoor")   
                || channel_sec_code.contains("ch2poker")
                || channel_sec_code.contains("redbull")                   
                || channel_sec_code.contains("weathernation")
                || channel_sec_code.contains("4uklive")                
            ) {
                error = '-NOTSUPPORTED-'
                log_text = log_text + error
                print error
                write_to_log(log_text)
                continue
            }                                                                        
                        
            //processChannel(channel_url)            
            
            def cache_key = cache_key_prefix + channel_sec_code
            
            items << new WebResourceItem(title: channel_sec_code, additionalInfo: [channelURL: channel_url, thumbnailURL: thumbnail_url, cacheKey: cache_key])

        }                        
        return new WebResourceContainer(title: showTitle, items: items)
    }
    
    ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {
        def rtmp_url = processChannel(item.additionalInfo.channelURL)
        if (rtmp_url.contains('-STREAM-')) {
            rtmp_url = rtmp_url.replaceFirst("-STREAM-", "")
        }
        else {
            return null
        }
                
        return new ContentURLContainer(
            contentUrl: rtmp_url, 
            thumbnailUrl: item.additionalInfo.thumbnailURL, 
            expiresImmediately: true, 
            cacheKey: item.additionalInfo.cacheKey,
            live: true
            )    
    }
    
    static void main(args) {
        
        MyiPlayer extractor = new  MyiPlayer()
        
        WebResourceContainer container = extractor.extractItems( new URL("http://www.myiplayer.com/sportchannels.php"), 5)
        /**/
        container.getItems().each {
            ContentURLContainer result = extractor.extractUrl(it, PreferredQuality.MEDIUM)
            println result 
        }
       /**/                  
    }
 }